#!/usr/bin/env python

"""
configurationdialog.py

Copyright (C) 2006 David Boddie

This file is part of PyPI Browser, a GUI browser for the Python Package Index.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
"""

import os, sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from ui_configurationdialog import Ui_ConfigurationDialog


class ConfigurationDialog(QDialog, Ui_ConfigurationDialog):

    """ConfigurationDialog(QDialog, Ui_ConfigurationDialog)
    
    Provides a configuration dialog with basic functionality for changing
    settings used by various components of the browser.
    """
    
    def __init__(self, settings, parent = None):
    
        QDialog.__init__(self, parent)
        self.setupUi(self)
        
        self.settings = settings
        self.versionPlaceholder.setText(
            self.tr("%1.%2.%3").arg(sys.version_info[0]).arg(
                sys.version_info[1]).arg(sys.version_info[2]))
        
        self.sitePackagesPlaceholder.setText("")
        directory = self.settings.value("Download directory")
        self.setDownloadDirectory(directory)
        
        self.connect(self.downloadButton, SIGNAL("clicked()"),
                     self.getDownloadDirectory)
    
    def getDownloadDirectory(self):
    
        """getDownloadDirectory(self)
        
        Ask the user to specify an existing directory using a standard file
        dialog for the browser to use when saving downloaded packages.
        If the new directory path is not valid, the current directory is
        retained.
        """
        
        path = QFileDialog.getExistingDirectory(self,
            self.tr("Choose Download Directory"))
        
        if not path.isNull():
            self.setDownloadDirectory(path)
    
    def setDownloadDirectory(self, directory):
    
        """setDownloadDirectory(self, directory)
        
        Sets the directory used by the browser to hold downloaded packages
        and updates the relevant field in the dialog.
        
        The directory must be specified using either a string or a QVariant
        that holds a string.
        
        If the directory is not valid, the field in the dialog is disabled,
        indicating that package downloading is disabled.
        """
        
        if isinstance(directory, QVariant):
            directory = directory.toString()
        
        if directory.isNull():
            self.downloadLineEdit.setEnabled(False)
        else:
            self.downloadLineEdit.setEnabled(True)
            self.downloadLineEdit.setText(directory)
            self.settings.setValue("Download directory", QVariant(directory))
